;-----------------------------------------------------------------------
;  Copyright  NetworkDLS 2002, All rights reserved
;
; THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF
; ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO
; THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A
; PARTICULAR PURPOSE.
;-----------------------------------------------------------------------

[Setup]
;-- Main Setup Information
 AppName                  = SQL-Exchange Server x86
 AppVerName               = SQL-Exchange Server x86 1.0.6.0
 AppCopyright             = Copyright  1995-2006 NetworkDLS
 DefaultDirName           = {pf}\NetworkDLS\SQL-Exchange\Server x86
 DefaultGroupName         = NetworkDLS\SQL-Exchange Server x86
 UninstallDisplayIcon     = {app}\SQLEServer.Exe
 WizardImageFile          = "Resources\WizModernImage-IS.bmp"
 WizardSmallImageFile     = "Resources\WizModernSmallImage-IS.bmp"
 PrivilegesRequired       = PowerUser
 Uninstallable            = Yes
 AppMutex                 = SQL-Exchange Server x86
 LicenseFile              = Resources\EULA.txt
 Compression              = BZIP/9
 OutputBaseFilename       = "..\..\Binary\SQLEServer x86 1.0.6.0"
;UninstallLogMode         = OverWrite
 DisableStartupPrompt     = Yes
 DirExistsWarning         = No

;-- Windows 2000 & XP (Support Dialog)
 AppPublisher    = NetworkDLS
 AppPublisherURL = http://www.NetworkDLS.com/
 AppUpdatesURL   = http://www.NetworkDLS.com/
 AppVersion      = 1.0.6.0

[Tasks]
 Name: CreateShortcuts;                Description: "Create start menu icons"; GroupDescription: "Shortcut Options:";
 Name: InstallService;                 Description: "Install as service";      GroupDescription: "System Service:";
 Name: InstallService\StartService;    Description: "Start the service";       GroupDescription: "System Service:";
 Name: InstallService\InstallAgent;    Description: "Install service agent";   GroupDescription: "System Service:"; Flags: UnChecked;

[Files]
 Source: "..\Binary\Win32\SQLEServer.Exe";            DestDir: "{app}";     Flags: IgnoreVersion RestartReplace;
 Source: "..\Binary\Win32\ServiceAgent.Exe";          DestDir: "{app}";     Flags: IgnoreVersion RestartReplace;
 Source: "Database\SQLExch_Index_Data.MDF";           DestDir: "{app}\DB";  Flags: IgnoreVersion RestartReplace;
 Source: "Database\SQLExch_Index_Log.LDF";            DestDir: "{app}\DB";  Flags: IgnoreVersion RestartReplace;

 Source: "Resources\EULA.txt";                        DestDir: "{app}";     Flags: IgnoreVersion;
 Source: "Resources\OpenDlg.ico";                     DestDir: "{app}";     Flags: IgnoreVersion;
 Source: "Resources\Start.ico";                       DestDir: "{app}";     Flags: IgnoreVersion;
 Source: "Resources\Stop.ico";                        DestDir: "{app}";     Flags: IgnoreVersion;
 Source: "Resources\OpenCon.ico";                     DestDir: "{app}";     Flags: IgnoreVersion;

 Source: "SQL\SQLExch_Create_DB.sql";                 DestDir: "{app}\SQL"; Flags: IgnoreVersion;

 Source: "..\SharedSource\EventMsg\EventMsg.dll";     DestDir: "{app}";     Flags: IgnoreVersion RestartReplace;

[Icons]
 Name: "{group}\Open Server";             Filename: "{app}\SQLEServer.Exe";   WorkingDir: "{app}"; Parameters: "/OpenMainDialog";                   IconFilename: "{app}\OpenDlg.ico";                          Tasks: CreateShortcuts AND InstallService
 Name: "{group}\Open Console";            Filename: "{app}\SQLEServer.Exe";   WorkingDir: "{app}"; Parameters: "/OpenConsole";                      IconFilename: "{app}\OpenCon.ico";                          Tasks: CreateShortcuts AND InstallService
 Name: "{group}\Start Service";           Filename: "{app}\SQLEServer.Exe";   WorkingDir: "{app}"; Parameters: "/Start";                            IconFilename: "{app}\Start.ico";                            Tasks: CreateShortcuts AND InstallService
 Name: "{group}\Stop Service";            Filename: "{app}\SQLEServer.Exe";   WorkingDir: "{app}"; Parameters: "/Stop";                             IconFilename: "{app}\Stop.ico";                             Tasks: CreateShortcuts AND InstallService
 Name: "{group}\Run StandAlone";          Filename: "{app}\SQLEServer.Exe";   WorkingDir: "{app}"; Parameters: "/NonService";                       IconFilename: "{app}\SQLEServer.exe";   IconIndex: 0;       Tasks: CreateShortcuts
 Name: "{commonstartup}\SQLESAgent x86";  Filename: "{app}\ServiceAgent.Exe"; WorkingDir: "{app}"; Parameters: """NetworkDLS_SQLExg_Server x86""";  IconFilename: "{app}\ServiceAgent.exe"; IconIndex: 0;       Tasks: CreateShortcuts AND InstallService\InstallAgent

[Dirs]
 Name: "{app}\Logs"
 Name: "{app}\Temp"
 Name: "{app}\DB"
 
[Registry]
 Root: HKLM; Subkey: "Software\NetworkDLS\SQL-Exchange\Server x86"; Flags: UninsDeleteKey

 Root: HKLM; Subkey: "Software\NetworkDLS\SQL-Exchange\Server x86"; ValueName: "CompressionMethod";  ValueType: String; ValueData: "GZIP";            Flags: CreateValueIfDoesntExist;
 Root: HKLM; Subkey: "Software\NetworkDLS\SQL-Exchange\Server x86"; ValueName: "Path";               ValueType: String; ValueData: "{app}";           Flags: CreateValueIfDoesntExist;
 Root: HKLM; Subkey: "Software\NetworkDLS\SQL-Exchange\Server x86"; ValueName: "SessionLogDir";      ValueType: String; ValueData: "{app}\Logs";      Flags: CreateValueIfDoesntExist;
 Root: HKLM; Subkey: "Software\NetworkDLS\SQL-Exchange\Server x86"; ValueName: "SQLDataFiles";       ValueType: String; ValueData: "{app}\DB";        Flags: CreateValueIfDoesntExist;
 Root: HKLM; Subkey: "Software\NetworkDLS\SQL-Exchange\Server x86"; ValueName: "DefaultDBO";         ValueType: String; ValueData: "DBO";             Flags: CreateValueIfDoesntExist;
 Root: HKLM; Subkey: "Software\NetworkDLS\SQL-Exchange\Server x86"; ValueName: "DatabaseMode";       ValueType: String; ValueData: "Standard";                  Flags: CreateValueIfDoesntExist;
 Root: HKLM; Subkey: "Software\NetworkDLS\SQL-Exchange\Server x86"; ValueName: "GUIPWD";             ValueType: Binary; ValueData: "";                Flags: CreateValueIfDoesntExist;

 Root: HKLM; Subkey: "Software\NetworkDLS\SQL-Exchange\Server x86"; ValueName: "AuthString";         ValueType: String; ValueData: "trIeSPiUhouDlUwRLe5hie2H5awRoupiaDi8zI0fo3Y7u6R703r7e6rLacrouChi";
 Root: HKLM; Subkey: "Software\NetworkDLS\SQL-Exchange\Server x86"; ValueName: "AuthKey";            ValueType: String; ValueData: "6riupiekieB8uphiuspi0tr6azl2piAth6us6ieko2zoap2818UviapHlEvo5joe";

 Root: HKLM; Subkey: "Software\NetworkDLS\SQL-Exchange\Server x86"; ValueName: "ImportTempDir";      ValueType: String; ValueData: "{app}\Temp";

 Root: HKLM; Subkey: "Software\NetworkDLS\SQL-Exchange\Server x86"; ValueName: "SQLIndexDatabase";   ValueType: String; ValueData: "SQLExch_Index";   Flags: CreateValueIfDoesntExist;
 Root: HKLM; Subkey: "Software\NetworkDLS\SQL-Exchange\Server x86"; ValueName: "SQLIndexDriver";     ValueType: String; ValueData: "{{SQL Server}";   Flags: CreateValueIfDoesntExist;
 Root: HKLM; Subkey: "Software\NetworkDLS\SQL-Exchange\Server x86"; ValueName: "SQLIndexPassword";   ValueType: String; ValueData: "";                Flags: CreateValueIfDoesntExist;
 Root: HKLM; Subkey: "Software\NetworkDLS\SQL-Exchange\Server x86"; ValueName: "SQLIndexServer";     ValueType: String; ValueData: "(Local)";         Flags: CreateValueIfDoesntExist;
 Root: HKLM; Subkey: "Software\NetworkDLS\SQL-Exchange\Server x86"; ValueName: "SQLIndexUserID";     ValueType: String; ValueData: "sa";              Flags: CreateValueIfDoesntExist;

 Root: HKLM; Subkey: "Software\NetworkDLS\SQL-Exchange\Server x86"; ValueName: "SQLCustDriver";      ValueType: String; ValueData: "{{SQL Server}";   Flags: CreateValueIfDoesntExist;
 Root: HKLM; Subkey: "Software\NetworkDLS\SQL-Exchange\Server x86"; ValueName: "SQLCustPassword";    ValueType: String; ValueData: "";                Flags: CreateValueIfDoesntExist;
 Root: HKLM; Subkey: "Software\NetworkDLS\SQL-Exchange\Server x86"; ValueName: "SQLCustServer";      ValueType: String; ValueData: "(Local)";         Flags: CreateValueIfDoesntExist;
 Root: HKLM; Subkey: "Software\NetworkDLS\SQL-Exchange\Server x86"; ValueName: "SQLCustUserID";      ValueType: String; ValueData: "sa";              Flags: CreateValueIfDoesntExist;

 Root: HKLM; Subkey: "Software\NetworkDLS\SQL-Exchange\Server x86"; ValueName: "ListenPort";         ValueType: Dword;  ValueData: "6796";            Flags: CreateValueIfDoesntExist;
 Root: HKLM; Subkey: "Software\NetworkDLS\SQL-Exchange\Server x86"; ValueName: "MaxClients";         ValueType: Dword;  ValueData: "10";              Flags: CreateValueIfDoesntExist;
 Root: HKLM; Subkey: "Software\NetworkDLS\SQL-Exchange\Server x86"; ValueName: "TCPLoopDelay";       ValueType: Dword;  ValueData: "1";               Flags: CreateValueIfDoesntExist;
 Root: HKLM; Subkey: "Software\NetworkDLS\SQL-Exchange\Server x86"; ValueName: "ShowSplashScreen";   ValueType: Dword;  ValueData: "1";               Flags: CreateValueIfDoesntExist;
 Root: HKLM; Subkey: "Software\NetworkDLS\SQL-Exchange\Server x86"; ValueName: "CacheLogFile";       ValueType: Dword;  ValueData: "1";               Flags: CreateValueIfDoesntExist;
 Root: HKLM; Subkey: "Software\NetworkDLS\SQL-Exchange\Server x86"; ValueName: "RTOFDWI";            ValueType: Dword;  ValueData: "1";               Flags: CreateValueIfDoesntExist;
 Root: HKLM; Subkey: "Software\NetworkDLS\SQL-Exchange\Server x86"; ValueName: "VisualAlertOnError"; ValueType: Dword;  ValueData: "0";               Flags: CreateValueIfDoesntExist;
 Root: HKLM; Subkey: "Software\NetworkDLS\SQL-Exchange\Server x86"; ValueName: "VisualAlertOnWarn";  ValueType: Dword;  ValueData: "0";               Flags: CreateValueIfDoesntExist;

 Root: HKLM; Subkey: "Software\NetworkDLS\SQL-Exchange\Server x86"; ValueName: "StartAutomatically";     ValueType: Dword;  ValueData: "1";               Flags: CreateValueIfDoesntExist;
 Root: HKLM; Subkey: "Software\NetworkDLS\SQL-Exchange\Server x86"; ValueName: "DropBadPackets";         ValueType: Dword;  ValueData: "0";               Flags: CreateValueIfDoesntExist;
 Root: HKLM; Subkey: "Software\NetworkDLS\SQL-Exchange\Server x86"; ValueName: "HashTimeoutMS";          ValueType: Dword;  ValueData: "1000";            Flags: CreateValueIfDoesntExist;
 Root: HKLM; Subkey: "Software\NetworkDLS\SQL-Exchange\Server x86"; ValueName: "KeyGenLength";           ValueType: Dword;  ValueData: "128";             Flags: CreateValueIfDoesntExist;
 Root: HKLM; Subkey: "Software\NetworkDLS\SQL-Exchange\Server x86"; ValueName: "NextClientID";           ValueType: Dword;  ValueData: "1";               Flags: CreateValueIfDoesntExist;
 Root: HKLM; Subkey: "Software\NetworkDLS\SQL-Exchange\Server x86"; ValueName: "PacketMode";             ValueType: Dword;  ValueData: "1";               Flags: CreateValueIfDoesntExist;
 Root: HKLM; Subkey: "Software\NetworkDLS\SQL-Exchange\Server x86"; ValueName: "PingTimeoutMS";          ValueType: Dword;  ValueData: "60000";           Flags: CreateValueIfDoesntExist;
 Root: HKLM; Subkey: "Software\NetworkDLS\SQL-Exchange\Server x86"; ValueName: "RawHashLen";             ValueType: Dword;  ValueData: "32";              Flags: CreateValueIfDoesntExist;
 Root: HKLM; Subkey: "Software\NetworkDLS\SQL-Exchange\Server x86"; ValueName: "CompressionLevel";       ValueType: Dword;  ValueData: "6";               Flags: CreateValueIfDoesntExist;

;--Create registry keys and values for Statistics
 Root: HKLM; Subkey: "Software\NetworkDLS\SQL-Exchange\Server x86\Statistics"; ValueName: "SessionConnections";        ValueType: Dword;  ValueData: "0";            Flags: CreateValueIfDoesntExist;
 Root: HKLM; Subkey: "Software\NetworkDLS\SQL-Exchange\Server x86\Statistics"; ValueName: "CurrentConnections";        ValueType: Dword;  ValueData: "0";            Flags: CreateValueIfDoesntExist;
 Root: HKLM; Subkey: "Software\NetworkDLS\SQL-Exchange\Server x86\Statistics"; ValueName: "SessionErrors";             ValueType: Dword;  ValueData: "0";            Flags: CreateValueIfDoesntExist;
 Root: HKLM; Subkey: "Software\NetworkDLS\SQL-Exchange\Server x86\Statistics"; ValueName: "SessionWarnings";           ValueType: Dword;  ValueData: "0";            Flags: CreateValueIfDoesntExist;
 Root: HKLM; Subkey: "Software\NetworkDLS\SQL-Exchange\Server x86\Statistics"; ValueName: "SessionUpTime";             ValueType: Dword;  ValueData: "0";            Flags: CreateValueIfDoesntExist;
 Root: HKLM; Subkey: "Software\NetworkDLS\SQL-Exchange\Server x86\Statistics"; ValueName: "SessionBytesSent";          ValueType: Dword;  ValueData: "0";            Flags: CreateValueIfDoesntExist;
 Root: HKLM; Subkey: "Software\NetworkDLS\SQL-Exchange\Server x86\Statistics"; ValueName: "SessionBytesRecv";          ValueType: Dword;  ValueData: "0";            Flags: CreateValueIfDoesntExist;

;--Create registry keys and values for Event Logs
 Root: HKLM; Subkey: "SYSTEM\CurrentControlSet\Services\Eventlog\SQL-Exchange\SQL-Exchange (Server) x86"; Flags: UninsDeleteKey

 Root: HKLM; Subkey: "SYSTEM\CurrentControlSet\Services\Eventlog\SQL-Exchange\SQL-Exchange (Server) x86"; ValueName: "TypesSupported";        ValueType: Dword;  ValueData: "7";                   Flags: CreateValueIfDoesntExist;
 Root: HKLM; Subkey: "SYSTEM\CurrentControlSet\Services\Eventlog\SQL-Exchange\SQL-Exchange (Server) x86"; ValueName: "EventMessageFile";      ValueType: String; ValueData: "{app}\EventMsg.dll";  Flags: CreateValueIfDoesntExist;

[UninstallDelete]
 Type: FilesAndOrDirs; Name: "{app}\Logs"

[Run]
 Filename: "{app}\SQLEServer.Exe";   Parameters: "/Install";                                        Tasks: InstallService;
 Filename: "{app}\SQLEServer.Exe";   Parameters: "/Start";                                          Tasks: InstallService\StartService;
 Filename: "{app}\ServiceAgent.Exe"; Parameters: """NetworkDLS_SQLExg_Server x86"""; Flags: NoWait; Tasks: InstallService\InstallAgent

[UninstallRun]
 Filename: "{app}\SQLEServer.Exe";    Parameters: "/Stop";   RunOnceId: "StopService";   MinVersion: 0, 4.0; Tasks: InstallService;
 Filename: "{app}\SQLEServer.Exe";    Parameters: "/Delete"; RunOnceId: "DeleteService"; MinVersion: 0, 4.0; Tasks: InstallService;
 Filename: "{app}\ServiceAgent.Exe";  Parameters: "/Close";  RunOnceId: "CloseAgent";    MinVersion: 0, 4.0; Tasks: InstallService\InstallAgent
 
